<link href="{{url('css/owl.carousel.min.css')}}" rel="stylesheet" type="text/css"/> <!-- (optional) owl css, safe to remove -->
<link href="{{url('css/owl.theme.default.min.css')}}" rel="stylesheet" type="text/css"/> <!-- (optional) owl css, safe to remove -->
{{-- @include('lang') --}}

@foreach($menu->menugenreshow->sortBy('genre.position')->reject(function ($item) {
  return $item->genre->id == 9;
}) as $genre)
  @if(isset($genre->genre) && $genre->genre != NULL)
    @php
      $moviegenreitems = [];

      // Collect MOVIES by genre
      foreach ($menu_data as $key => $item) {
        $gmovie = App\Movie::join('videolinks','videolinks.movie_id','=','movies.id')
          ->select(
            'movies.id as id','movies.title as title','movies.type as type','movies.status as status',
            'movies.genre_id as genre_id','movies.thumbnail as thumbnail','movies.rating as rating',
            'movies.duration as duration','movies.publish_year as publish_year',
            'movies.maturity_rating as maturity_rating','movies.detail as detail',
            'movies.trailer_url as trailer_url','videolinks.iframeurl as iframeurl','movies.slug as slug',
            'movies.tmdb as tmdb','movies.is_custom_label as is_custom_label','movies.label_id as label_id'
          )
          ->where('movies.is_upcoming','!=',1)
          ->where('movies.genre_id','LIKE','%'.$genre->genre->id.'%')
          ->where('movies.id',$item->movie_id)
          ->first();

        if($gmovie){ $moviegenreitems[] = $gmovie; }
        if($section->order == 1){ arsort($moviegenreitems); }
        if(count($moviegenreitems) == $section->item_limit){ break; }
      }

      $moviegenreitems = array_values(array_filter($moviegenreitems));

      // Collect TV SERIES by genre
      foreach ($menu_data as $key => $item) {
        $gtvs = App\Tvseries::join('seasons','seasons.tv_series_id','=','tv_series.id')
          ->join('episodes','episodes.seasons_id','=','seasons.id')
          ->join('videolinks','videolinks.episode_id','=','episodes.id')
          ->select(
            'seasons.id as seasonid','tv_series.genre_id as genre_id','tv_series.id as id','tv_series.type as type',
            'tv_series.status as status','tv_series.thumbnail as thumbnail','tv_series.title as title',
            'tv_series.rating as rating','seasons.publish_year as publish_year','tv_series.maturity_rating as age_req',
            'tv_series.detail as detail','seasons.season_no as season_no','videolinks.iframeurl as iframeurl',
            'seasons.trailer_url as trailer_url','seasons.tmdb as tmdb','tv_series.is_custom_label as is_custom_label',
            'tv_series.label_id as label_id'
          )
          ->where('tv_series.genre_id','LIKE','%'.$genre->genre->id.'%')
          ->where('tv_series.id',$item->tv_series_id)
          ->first();

        if($gtvs){ $moviegenreitems[] = $gtvs; }
        if($section->order == 1){ arsort($moviegenreitems); }
        if(count($moviegenreitems) == $section->item_limit * 2){ break; }
      }

      $moviegenreitems = array_values(array_filter($moviegenreitems));

      // Add "Watch More" card
      $obj = App\Movie::join('videolinks','videolinks.movie_id','=','movies.id')
        ->select(
          'movies.id as id','movies.title as title','movies.type as type','movies.status as status',
          'movies.genre_id as genre_id','movies.thumbnail as thumbnail','movies.rating as rating',
          'movies.duration as duration','movies.publish_year as publish_year',
          'movies.maturity_rating as maturity_rating','movies.detail as detail',
          'movies.trailer_url as trailer_url','videolinks.iframeurl as iframeurl','movies.slug as slug',
          'movies.tmdb as tmdb','movies.is_custom_label as is_custom_label','movies.label_id as label_id'
        )
        ->where('movies.is_upcoming','!=',1)
        ->where('movies.genre_id','LIKE','%'.$genre->genre->id.'%')
        ->first();

      if ($obj) {
        $obj->id = 150000;
        $obj->thumbnail = "watchMore.png";
        $moviegenreitems[] = $obj;
      }
    @endphp

    <div class="">
      @if($moviegenreitems && count($moviegenreitems) > 0)
        <h5 class="section-heading">{{ $genre->genre->name }}</h5>

        @if($auth && getSubscription()->getData()->subscribed == true)
          <a href="{{ route('show.in.genre',$genre->genre->id) }}" class="see-more"><b>{{ __('staticwords.viewall') }}</b></a>
        @else
          <a href="{{ route('show.in.guest.genre',$genre->genre->id) }}" class="see-more"><b>{{ __('staticwords.viewall') }}</b></a>
        @endif
      @endif

      @if($section->view == 1)
        {{-- ***** NEW: Grid (no Owl) ***** --}}
        <div class="movie-grid">
          @foreach($moviegenreitems as $item)
            @php
              // Wishlist checks (kept)
              if(isset($auth) && $auth != NULL){
                if ($item->type == 'M') {
                  $wishlist_check = \Illuminate\Support\Facades\DB::table('wishlists')->where([
                    ['user_id','=',$auth->id],
                    ['movie_id','=',$item->id],
                  ])->first();
                }
              }

              if(isset($auth) && $auth != NULL){
                $gets1 = App\Season::where('tv_series_id','=',$item->id)->first();
                if (isset($gets1)) {
                  $wishlist_check = \Illuminate\Support\Facades\DB::table('wishlists')->where([
                    ['user_id','=',$auth->id],
                    ['season_id','=',$gets1->id],
                  ])->first();
                }
              } else {
                $gets1 = App\Season::where('tv_series_id','=',$item->id)->first();
              }

              // Build image src per item
              $src = url('images/default-thumbnail.jpg');
              if($item->type == 'M' && !empty($item->thumbnail)){
                $imagePath = public_path('images/movies/thumbnails/'.$item->thumbnail);
                if (is_file($imagePath)) {
                  $data = @base64_encode(@file_get_contents($imagePath));
                  if($data){ $src = 'data:'.mime_content_type($imagePath).';base64,'.$data; }
                }
              } elseif ($item->type == 'T' && !empty($item->thumbnail)) {
                $imagePath = public_path('images/tvseries/thumbnails/'.$item->thumbnail);
                if (is_file($imagePath)) {
                  $data = @base64_encode(@file_get_contents($imagePath));
                  if($data){ $src = 'data:'.mime_content_type($imagePath).';base64,'.$data; }
                }
              }

              $isSubscribed = isset($auth) && $auth && optional(getSubscription()->getData())->subscribed === true;

              // Build href for movie/TV + special 150000 "view all"
              if ($item->id == 150000) {
                $href = $isSubscribed
                  ? route('show.in.genre',$genre->genre->id)
                  : route('show.in.guest.genre',$genre->genre->id);
              } else {
                if ($item->type == 'M') {
                  $href = $isSubscribed ? url('movie/detail', $item->slug)
                                        : url('movie/guest/detail', $item->slug);
                } else { // TV
                  if($isSubscribed){
                    $href = isset($gets1) ? url('show/detail', $gets1->season_slug) : '#';
                  } else {
                    $href = isset($gets1) ? url('show/guest/detail', $gets1->season_slug) : '#';
                  }
                }
              }
            @endphp

            @if($item->status == 1)
              <a class="movie-card protip"
                 href="{{ $href }}"
                 @if($item->id == 150000) target="_blank" rel="noopener" @endif
                 data-pt-placement="outside"
                 data-pt-title="#prime-mix-description-block{{$item->id}}{{ $item->type == 'T' ? $item->type : '' }}"
              >
                <div class="movie-thumb">
                  <img class="lazy-img" data-src="{{ $src }}" alt="{{ $item->title }}">
                  @if(isset($item->is_custom_label) && $item->is_custom_label == 1 && isset($item->label_id))
                    <span class="movie-badge">{{ $item->label->name }}</span>
                  @endif
                </div>
                <div class="movie-meta">
                  <p class="movie-title">{{ $item->title }}</p>
                </div>
              </a>

              {{-- Descriptions (kept) --}}
              @if(isset($protip) && $protip == 1)
                @if($item->type == 'M')
                  <div id="prime-mix-description-block{{$item->id}}" class="prime-description-block">
                    <h5 class="description-heading">{{ $item->title }}</h5>
                    <ul class="description-list">
                      <li>{{ __('staticwords.tmdbrating') }} {{ $item->rating }}</li>
                      <li>{{ $item->duration }} {{ __('staticwords.mins') }}</li>
                      <li>{{ $item->publish_year }}</li>
                      <li>{{ $item->maturity_rating }}</li>
                    </ul>
                    <div class="main-des">
                      <p>{{ $item->detail }}</p>
                      <a href="#"></a>
                    </div>
                    <div class="des-btn-block">
                      @if($auth && $isSubscribed)
                        @if($item->is_upcoming != 1)
                          @if(checkInMovie($item) == true)
                            @if($item->maturity_rating == 'all age' || (isset($age) && $age>=str_replace('+', '', $item->maturity_rating)))
                              @if(isset($item->video_link['iframeurl']) && $item->video_link['iframeurl'])
                                <a href="{{ route('watchmovieiframe',$item->id) }}" class="btn btn-play iframe">
                                  <span class="play-btn-icon"><i class="fa fa-play"></i></span>
                                  <span class="play-text">{{ __('staticwords.playnow') }}</span>
                                </a>
                              @else
                                <a href="{{ route('watchmovie',$item->id) }}" class="iframe btn btn-play">
                                  <span class="play-btn-icon"><i class="fa fa-play"></i></span>
                                  <span class="play-text">{{ __('staticwords.playnow') }}</span>
                                </a>
                              @endif
                            @else
                              <a onclick="myage({{ $age ?? 0 }})" class="btn btn-play">
                                <span class="play-btn-icon"><i class="fa fa-play"></i></span>
                                <span class="play-text">{{ __('staticwords.playnow') }}</span>
                              </a>
                            @endif
                          @endif
                        @endif
                        @if($item->trailer_url)
                          <a class="iframe btn btn-default" href="{{ route('watchTrailer',$item->id) }}">{{ __('staticwords.watchtrailer') }}</a>
                        @endif
                      @else
                        @if($item->trailer_url)
                          <a class="iframe btn btn-default" href="{{ route('guestwatchtrailer',$item->id) }}">{{ __('staticwords.watchtrailer') }}</a>
                        @endif
                      @endif

                      @if(isset($catlog) && $catlog==0 && $isSubscribed)
                        @if (isset($wishlist_check->added))
                          <button onclick="addWish({{ $item->id }},'{{ $item->type }}')" class="addwishlistbtn{{ $item->id }}{{ $item->type }} btn-default">
                            {{ $wishlist_check->added == 1 ? __('staticwords.removefromwatchlist') : __('staticwords.addtowatchlist') }}
                          </button>
                        @else
                          <button onclick="addWish({{ $item->id }},'{{ $item->type }}')" class="addwishlistbtn{{ $item->id }}{{ $item->type }} btn-default">
                            {{ __('staticwords.addtowatchlist') }}
                          </button>
                        @endif
                      @elseif(isset($catlog) && $catlog == 1 && isset($auth) && $auth)
                        @if (isset($wishlist_check->added))
                          <button onclick="addWish({{ $item->id }},'{{ $item->type }}')" class="addwishlistbtn{{ $item->id }}{{ $item->type }} btn-default">
                            {{ $wishlist_check->added == 1 ? __('staticwords.removefromwatchlist') : __('staticwords.addtowatchlist') }}
                          </button>
                        @else
                          <button onclick="addWish({{ $item->id }},'{{ $item->type }}')" class="addwishlistbtn{{ $item->id }}{{ $item->type }} btn-default">
                            {{ __('staticwords.addtowatchlist') }}
                          </button>
                        @endif
                      @endif
                    </div>
                  </div>
                @endif

                @if($item->type == 'T')
                  <div id="prime-mix-description-block{{$item->id}}{{$item->type}}" class="prime-description-block">
                    <h5 class="description-heading">{{ $item->title }}</h5>
                    <div class="movie-rating">{{ __('staticwords.tmdbrating') }} {{ $item->rating }}</div>
                    <ul class="description-list">
                      <li>{{ __('staticwords.season') }} {{ $item->season_no }}</li>
                      <li>{{ $item->publish_year }}</li>
                      <li>{{ $item->age_req }}</li>
                    </ul>
                    <div class="main-des">
                      <p>{{ $item->detail }}</p>
                      <a href="#"></a>
                    </div>

                    <div class="des-btn-block">
                      @if($auth && $isSubscribed)
                        @if (isset($gets1->episodes[0]) && checkInTvseries($item) == true)
                          @if($item->age_req == 'all age' || (isset($age) && $age>=str_replace('+', '', $item->age_req)))
                            @if(!empty($gets1->episodes[0]->video_link['iframeurl']))
                              <a href="#" onclick="playoniframe('{{ $gets1->episodes[0]->video_link['iframeurl'] }}','{{ $gets1->episodes[0]->seasons->tvseries->id }}','tv')" class="btn btn-play">
                                <span class="play-btn-icon"><i class="fa fa-play"></i></span>
                                <span class="play-text">{{ __('staticwords.playnow') }}</span>
                              </a>
                            @else
                              <a href="{{ route('watchTvShow',$item->seasonid) }}" class="iframe btn btn-play">
                                <span class="play-btn-icon"><i class="fa fa-play"></i></span>
                                <span class="play-text">{{ __('staticwords.playnow') }}</span>
                              </a>
                            @endif
                          @else
                            <a onclick="myage({{ $age ?? 0 }})" class="btn btn-play">
                              <span class="play-btn-icon"><i class="fa fa-play"></i></span>
                              <span class="play-text">{{ __('staticwords.playnow') }}</span>
                            </a>
                          @endif
                        @endif
                        @if($item->trailer_url)
                          <a href="{{ route('watchtvTrailer',$item->id) }}" class="iframe btn btn-default">{{ __('staticwords.watchtrailer') }}</a>
                        @endif
                      @else
                        @if($item->trailer_url)
                          <a href="{{ route('guestwatchtvtrailer',$item->id) }}" class="iframe btn btn-default">{{ __('staticwords.watchtrailer') }}</a>
                        @endif
                      @endif

                      @if(isset($catlog) && $catlog == 0 && $isSubscribed)
                        @if(isset($gets1))
                          @if (isset($wishlist_check->added))
                            <a onclick="addWish({{ $item->seasonid }},'{{ $gets1->type }}')" class="addwishlistbtn{{ $item->seasonid }}{{ $gets1->type }} btn-default">
                              {{ $wishlist_check->added == 1 ? __('staticwords.removefromwatchlist') : __('staticwords.addtowatchlist') }}
                            </a>
                          @else
                            <a onclick="addWish({{ $item->seasonid }},'{{ $gets1->type }}')" class="addwishlistbtn{{ $item->seasonid }}{{ $gets1->type }} btn-default">
                              {{ __('staticwords.addtowatchlist') }}
                            </a>
                          @endif
                        @endif
                      @elseif(isset($catlog) && $catlog == 1 && isset($auth) && $auth)
                        @if(isset($gets1))
                          @if (isset($wishlist_check->added))
                            <a onclick="addWish({{ $item->seasonid }},'{{ $gets1->type }}')" class="addwishlistbtn{{ $item->seasonid }}{{ $gets1->type }} btn-default">
                              {{ $wishlist_check->added == 1 ? __('staticwords.removefromwatchlist') : __('staticwords.addtowatchlist') }}
                            </a>
                          @else
                            <a onclick="addWish({{ $item->seasonid }},'{{ $gets1->type }}')" class="addwishlistbtn{{ $item->seasonid }}{{ $gets1->type }} btn-default">
                              {{ __('staticwords.addtowatchlist') }}
                            </a>
                          @endif
                        @endif
                      @endif
                    </div>
                  </div>
                @endif
              @endif
            @endif
          @endforeach
        </div>
        {{-- ***** /Grid ***** --}}
      @endif
    </div>
  @endif
@endforeach


@section('custom-script')
<script>
/* Lazy-load for data-src images (no Owl needed) */
(function(){
  const imgs = document.querySelectorAll('img.lazy-img[data-src]');
  if('IntersectionObserver' in window){
    const io = new IntersectionObserver((entries, obs)=>{
      entries.forEach(entry=>{
        if(entry.isIntersecting){
          const img = entry.target;
          img.src = img.getAttribute('data-src');
          img.removeAttribute('data-src');
          img.classList.remove('lazy-img');
          obs.unobserve(img);
        }
      });
    }, { rootMargin:'200px 0px' });
    imgs.forEach(img=>io.observe(img));
  } else {
    imgs.forEach(img=>{ img.src = img.getAttribute('data-src'); img.removeAttribute('data-src'); });
  }
})();
</script>

<style>
  /* --- Responsive square cover --- */
.cover-wrapper {
  width: 100%;
  max-width: 500px;      /* limit width on large screens if you want */
  aspect-ratio: 1 / 1;   /* keeps it perfectly square */
  margin: 0 auto;        /* centers horizontally */
  display: flex;
  justify-content: center;
  align-items: center;
  overflow: hidden;      /* crop overflow if needed */
  border-radius: 12px;   /* optional rounded corners */
}

.cover-wrapper img {
  width: 100%;
  height: 100%;
  object-fit: cover;     /* keeps image filling the square */
  display: block;
}

/* Minimal, responsive grid + card styling */
.movie-grid{display:grid;gap:16px;grid-template-columns:repeat(2,minmax(0,1fr))}
@media (min-width:480px){.movie-grid{grid-template-columns:repeat(3,minmax(0,1fr))}}
@media (min-width:768px){.movie-grid{grid-template-columns:repeat(4,minmax(0,1fr))}}
@media (min-width:1024px){.movie-grid{grid-template-columns:repeat(6,minmax(0,1fr))}}
.movie-card{display:flex;flex-direction:column;text-decoration:none;background:#111;border-radius:10px;overflow:hidden;border:1px solid rgba(255,255,255,.06);transition:transform .18s ease,box-shadow .18s ease}
.movie-card:hover{transform:translateY(-2px);box-shadow:0 6px 16px rgba(0,0,0,.35)}
.movie-thumb{position:relative;aspect-ratio:16/9;background:#1e1e1e}
.movie-thumb img{width:100%;height:100%;object-fit:cover;display:block}
.movie-badge{position:absolute;top:10px;left:10px;background:#1a604c;color:#fff;font-size:12px;padding:4px 8px;border-radius:999px;line-height:1}
.movie-meta{padding:10px 12px 12px}
.movie-title{margin:0;color:#e6f4ee;font-weight:600;font-size:.95rem;line-height:1.25rem;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden}
</style>

 
<script>

      function myage(age){
        if (age==0) {
        $('#ageModal').modal('show'); 
      }else{
          $('#ageWarningModal').modal('show');
      }
    }
   
</script>
<script type="text/javascript">
    var app = new Vue({
      el: '.des-btn-block',
      data: {
        result: {
          id: '',
          type: '',
        },
      },
      methods: {
        addToWishList(id, type) {
          this.result.id = id;
          this.result.type = type;
          this.$http.post('{{route('addtowishlist')}}', this.result).then((response) => {
          }).catch((e) => {
            console.log(e);
          });
          this.result.item_id = '';
          this.result.item_type = '';
        }
      }
    });

    function addWish(id, type) {
      app.addToWishList(id, type);
      setTimeout(function() {
        $('.addwishlistbtn'+id+type).text(function(i, text){
          return text == "{{__('staticwords.addtowatchlist')}}" ? "{{ __('staticwords.removefromwatchlist') }}" : "{{__('staticwords.addtowatchlist')}}";
        });
      }, 100);
    }
  </script>
 @endsection                  

<script type="text/javascript" src="{{url('js/jquery.popover.js')}}"></script> <!-- bootstrap popover js -->
<script type="text/javascript" src="{{url('js/menumaker.js')}}"></script> <!-- menumaker js -->
<script type="text/javascript" src="{{url('js/jquery.curtail.min.js')}}"></script> <!-- menumaker js -->
@if(selected_lang()->rtl == 0)
<script type="text/javascript" src="{{url('js/owl.carousel.min.js')}}"></script> 
<script type="text/javascript" src="{{ url('js/slider.js') }}"></script>
@else
<script type="text/javascript" src="{{url('js/owl-carousel-rtl-js/owl.carousel.min.js')}}"></script> <!-- owl carousel js -->
<script type="text/javascript" src="{{ url('js/slider-rtl.js') }}"></script>
@endif

<script type="text/javascript" src="{{url('js/jquery.scrollSpeed.js')}}"></script> <!-- owl carousel js -->
<script type="text/javascript" src="{{url('js/TweenMax.min.js')}}"></script> <!-- animation gsap js -->
<script type="text/javascript" src="{{url('js/ScrollMagic.min.js')}}"></script> <!-- custom js -->
<script type="text/javascript" src="{{url('js/animation.gsap.min.js')}}"></script> <!-- animation gsap js -->
<script type="text/javascript" src="{{url('js/modernizr-custom.js')}}"></script> <!-- debug addIndicators js -->
<script type="text/javascript" src="{{url('js/theme.js')}}"></script> <!-- custom js -->
<script type="text/javascript" src="{{url('js/custom-js.js')}}"></script>
<script type="text/javascript" src="{{ url('js/colorbox.js') }}"></script>
<script type="text/javascript" src="{{ url('js/checkit.js') }}"></script>
{{-- start rating js --}}
<script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-star-rating/4.0.2/js/star-rating.min.js"></script>